/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.minetogether.chat.DisplayableMessage;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.polylib.gui.PreviewRenderer;
import net.creeperhost.minetogether.util.MessageFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class ChatScrollList
extends AbstractSelectionList<ChatLine> {
    public final int width;
    @Nullable
    private IrcChannel channel;
    @Nullable
    private IrcChannel.ChatListener listener;
    private final List<ScrollListDisplayableMessage> changedMessages = new LinkedList<ScrollListDisplayableMessage>();
    private final List<Message> pendingMessages = new LinkedList<Message>();
    private final List<ScrollListDisplayableMessage> messages = new LinkedList<ScrollListDisplayableMessage>();
    private final PreviewRenderer previewRenderer = new PreviewRenderer(5, 5, 80, 60){

        @Override
        protected URL getUrlUnderMouse(int mouseX, int mouseY) {
            ChatLine line = ChatScrollList.this.getEntry(mouseX, mouseY);
            if (line == null) {
                return null;
            }
            Style style = ((ChatScrollList)ChatScrollList.this).f_93386_.f_91062_.m_92865_().m_92338_(line.formattedMessage, mouseX - ChatScrollList.this.m_5747_());
            if (style == null) {
                return null;
            }
            HoverEvent event = style.m_131186_();
            if (event == null || event.m_130820_() != MessageFormatter.SHOW_URL_PREVIEW) {
                return null;
            }
            Component value = (Component)event.m_130823_(MessageFormatter.SHOW_URL_PREVIEW);
            try {
                return new URL(value.getString());
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
    };

    public ChatScrollList(Minecraft minecraft, int width, int height, int y0, int y1) {
        super(minecraft, width, height, y0, y1, 10);
        this.width = width;
    }

    public void attach(@Nullable IrcChannel channel) {
        if (this.channel != null) {
            assert (this.listener != null);
            this.channel.removeListener(this.listener);
            this.listener = null;
        }
        this.pendingMessages.clear();
        for (ScrollListDisplayableMessage message : this.messages) {
            message.onDead();
        }
        this.messages.clear();
        this.m_93516_();
        this.channel = channel;
        if (channel != null) {
            this.pendingMessages.addAll(channel.getMessages());
            this.listener = channel.addListener(e -> {
                List<Message> list = this.pendingMessages;
                synchronized (list) {
                    this.pendingMessages.add(e);
                }
            });
        }
    }

    private void addMessage(Message message) {
        boolean maxScroll = this.m_93517_() == (double)this.m_93518_();
        ScrollListDisplayableMessage newMessage = new ScrollListDisplayableMessage(message);
        this.messages.add(newMessage);
        newMessage.display();
        if (maxScroll) {
            this.m_93410_(this.m_93518_());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6305_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        List<Object> list;
        if (!this.pendingMessages.isEmpty()) {
            list = this.pendingMessages;
            synchronized (list) {
                for (Message pendingMessage : this.pendingMessages) {
                    this.addMessage(pendingMessage);
                }
                this.pendingMessages.clear();
            }
        }
        if (!this.changedMessages.isEmpty()) {
            list = this.changedMessages;
            synchronized (list) {
                for (ScrollListDisplayableMessage changedMessage : this.changedMessages) {
                    changedMessage.reformat();
                }
                this.changedMessages.clear();
            }
        }
        super.m_6305_(pStack, mouseX, mouseY, partialTicks);
        this.previewRenderer.m_6305_(pStack, mouseX, mouseY, partialTicks);
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public int m_5759_() {
        return this.width;
    }

    protected int m_5756_() {
        return this.width + 2;
    }

    public void removed() {
        if (this.channel != null) {
            assert (this.listener != null);
            this.channel.removeListener(this.listener);
        }
        for (ScrollListDisplayableMessage message : this.messages) {
            message.onDead();
        }
        this.messages.clear();
        this.m_93516_();
    }

    @Nullable
    public IrcChannel getChannel() {
        return this.channel;
    }

    public boolean m_6375_(double d, double e, int i) {
        return false;
    }

    @Nullable
    public ChatLine getEntry(double mouseX, double mouseY) {
        return (ChatLine)this.m_93412_(mouseX, mouseY);
    }

    public int getTop() {
        return this.f_93390_;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.f_93389_;
    }

    private class ScrollListDisplayableMessage
    extends DisplayableMessage<ChatLine> {
        private ScrollListDisplayableMessage(Message message) {
            super(message);
        }

        @Override
        public void display() {
            this.format();
            ChatScrollList.this.m_6702_().addAll(this.getTrimmedLines());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onModified() {
            List<ScrollListDisplayableMessage> list = ChatScrollList.this.changedMessages;
            synchronized (list) {
                ChatScrollList.this.changedMessages.add(this);
            }
        }

        @Override
        protected boolean isForward() {
            return true;
        }

        @Override
        protected ChatLine createMessage(int addTime, FormattedCharSequence message) {
            return new ChatLine(ChatScrollList.this, this.getMessage(), message);
        }

        @Override
        protected int getMessageIndex(ChatLine message) {
            return ChatScrollList.this.m_6702_().indexOf((Object)message);
        }

        @Override
        protected void clearMessages() {
            this.getTrimmedLines().forEach(x$0 -> ChatScrollList.this.m_93502_(x$0));
        }

        @Override
        protected void addMessage(int index, ChatLine message) {
            ChatScrollList.this.m_6702_().add(index, message);
        }

        @Override
        protected double getChatWidth() {
            return ChatScrollList.this.m_5759_();
        }
    }

    public static class ChatLine
    extends AbstractSelectionList.Entry<ChatLine> {
        private final ChatScrollList parent;
        public final FormattedCharSequence formattedMessage;
        public final Message message;

        public ChatLine(ChatScrollList parent, Message message, FormattedCharSequence formattedMessage) {
            this.parent = parent;
            this.message = message;
            this.formattedMessage = formattedMessage;
        }

        public void m_6311_(PoseStack poseStack, int idx, int top, int left, int width, int height, int mx, int my, boolean hovered, float partialTicks) {
            GuiComponent.m_168756_((PoseStack)poseStack, (Font)((ChatScrollList)this.parent).f_93386_.f_91062_, (FormattedCharSequence)this.formattedMessage, (int)left, (int)top, (int)-1);
        }

        public boolean m_6375_(double d, double e, int i) {
            return false;
        }
    }
}

